/*1D FDTD Schroedinger simulation*/
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
//#include "Definiton.h"

#define KE 14
const int CountFreq=1200;
double SweepFreq[CountFreq];
double Real_Point[CountFreq][KE];
double Imag_Point[CountFreq][KE];
double Real_Ref[CountFreq];
double Imag_Ref[CountFreq];

int main()
{
	double psi_rl[KE],psi_im[KE];

	int n,k,kc,ke,kstart,kcenter,NSTEPS,n_pml;

	double P; 
	double pi,melec,hbar;
	double ddx,dt,ra;

	FILE *fp;
	double lap_rl,lap_im,ke_rl,ke_im,kine,PE,s1,s2;
	double RealTime=0;
	double Fourier_Frq=0;  


	int TIMESTAGE=3;


	for(k=0;k<KE;k++)
	{
		psi_rl[k]=0.;
		psi_im[k]=0.;
	}

	pi=3.141592653589793;
	melec=9.10938188e-31;
	hbar=1.05457148e-34;
	double const1=8637.993775443278;  //melec/hbar

	ddx=2.5*pow(10.0,-4.0);

	double stab=0.5;
	//ra=0.5*stab;
	dt=stab*(const1)*pow(ddx,2.0);

	ra=(dt/(ddx*ddx))*(hbar/(2*melec));

	//printf("ra=%e\n",ra);
	//printf("dt=%e\n",dt);

	int Pos=int(KE/2+3);

	psi_rl[Pos]=1;
	psi_im[Pos]=0;

	//psi_rl[Pos+1]=1/4;
	//psi_im[Pos+1]=1/4;
	double D[3]={0.91966152301739985705089763815343,-0.1879916187991597820078528680789,0.2683300957817599249569552299255};

	double ra1[3]={0,0,0};

	double ra2[3]={0,0,0};

	double C[3]={0.2683300957817599249569552299255,-0.1879916187991597820078528680789,0.91966152301739985705089763815343};

	double TimeTableH[3]={C[0],C[0]+C[1],C[0]+C[1]+C[2]}; 

	const double TimeTableE[3]={0,D[0],D[0]+D[1]};  //SFDTD



	//exit(0);
	int i;

	int w;
	for (w=0;w<CountFreq; w++)
	{
		SweepFreq[w]=1+0.5*w;
	}

	for (w=0; w<CountFreq; w++)
	{
		Real_Ref[w]=0.;
		Imag_Ref[w]=0.;

		for ( int j=0; j<KE; j++)
		{
			Real_Point[w][j]=0.;
			Imag_Point[w][j]=0.;
		}
	}


	NSTEPS=41000;

	for (n=0;n<=NSTEPS;n++)
	{
		for (int i=0; i<TIMESTAGE; i++) 
		{
			printf("%d\n",n);

			s1=C[i]*dt;

	

			psi_rl[1]=exp(-s1)*psi_rl[1]-1.0/12*ra*(1-exp(-s1))/(s1)*(psi_im[5]-6*psi_im[4]+14*psi_im[3]-4*psi_im[2]-15*psi_im[1]);


			psi_rl[KE-2]=exp(-s1)*psi_rl[KE-2]-1.0/12*ra*(1-exp(-s1))/(s1)*(psi_im[KE-6]-6*psi_im[KE-5]+14*psi_im[KE-4]-4*psi_im[KE-3]-15*psi_im[KE-2]);

			//psi_rl[1]=ra1[i]*psi_rl[1]-1.0/12*ra2[i]*((1)*psi_im[1]+16*psi_im[0]-\
				30*psi_im[1]+16*psi_im[2]-1*psi_im[3]);

			//psi_rl[KE-2]=ra1[i]*psi_rl[KE-2]-1.0/12*ra2[i]*((-1)*psi_im[KE-4]+16*psi_im[KE-3]-\
				30*psi_im[KE-2]+16*psi_im[KE-1]+1*psi_im[KE-2]);


			for (k=2;k<KE-2;k++)
			{
				
				psi_rl[k]=exp(-s1)*psi_rl[k]-1.0/12*ra*(1-exp(-s1))/(s1)*((-1)*psi_im[k-2]+16*psi_im[k-1]-\
					30*psi_im[k]+16*psi_im[k+1]-1*psi_im[k+2]);
			}

			psi_rl[0]=0.;
			psi_rl[KE-1]=0.;

			s2=D[i]*dt;


			psi_im[1]=exp(-s2)*psi_im[1]+1.0/12*ra*(1-exp(-s2))/(s2)*(psi_rl[5]-6*psi_rl[4]+14*psi_rl[3]-4*psi_rl[2]-15*psi_rl[1]);

			psi_im[KE-2]=exp(-s2)*psi_im[KE-2]+1.0/12*ra*(1-exp(-s2))/(s2)*(psi_rl[KE-6]-6*psi_rl[KE-5]+14*psi_rl[KE-4]-4*psi_rl[KE-3]-15*psi_rl[KE-2]);

			//psi_im[KE-2]=ra1[i]*psi_im[KE-2]+1.0/12*ra2[i]*((-1)*psi_rl[KE-4]+16*psi_rl[KE-3]-\
				30*psi_rl[KE-2]+16*psi_rl[KE-1]+1*psi_rl[KE-2]);

			//psi_im[1]=ra1[i]*psi_im[1]+1.0/12*ra2[i]*((1)*psi_rl[1]+16*psi_rl[0]-\
				30*psi_rl[1]+16*psi_rl[2]-1*psi_rl[3]);


			for (k=2;k<KE-2;k++)
			{
				
				psi_im[k]=exp(-s2)*psi_im[k]+1.0/12*ra*(1-exp(-s2))/(s2)*((-1)*psi_rl[k-2]+16*psi_rl[k-1]-\
					30*psi_rl[k]+16*psi_rl[k+1]-1*psi_rl[k+2]);
			}

			psi_im[0]=0.;
			psi_im[KE-1]=0.;

			//RealTime=(n+1)*dt;   //ʱ

			RealTime=(n+TimeTableH[i])*dt;	


			for (w=0; w<CountFreq; w++)
			{
				Fourier_Frq=SweepFreq[w];

				//Real_Ref[w]=Real_Ref[w]+cos(Fourier_Frq*RealTime)*psi_rl[Pos]+sin(Fourier_Frq*RealTime)*psi_im[Pos];
				//Imag_Ref[w]=Imag_Ref[w]+cos(Fourier_Frq*RealTime)*psi_im[Pos]-sin(Fourier_Frq*RealTime)*psi_rl[Pos];

				Real_Ref[w]=Real_Ref[w]+cos(Fourier_Frq*RealTime)*psi_rl[Pos];
				Imag_Ref[w]=Imag_Ref[w]-sin(Fourier_Frq*RealTime)*psi_rl[Pos];

				for (i=1; i<KE-1; i++)
				{
					//Real_Point[w][i]=Real_Point[w][i]+cos(Fourier_Frq*RealTime)*psi_rl[i]+sin(Fourier_Frq*RealTime)*psi_im[i];
					//Imag_Point[w][i]=Imag_Point[w][i]+cos(Fourier_Frq*RealTime)*psi_im[i]-sin(Fourier_Frq*RealTime)*psi_rl[i];

					Real_Point[w][i]=Real_Point[w][i]+cos(Fourier_Frq*RealTime)*psi_rl[i];
					Imag_Point[w][i]=Imag_Point[w][i]-sin(Fourier_Frq*RealTime)*psi_rl[i];
				}
			}
		}
	}

	fp=fopen("power_SFDTD.txt","w");

	for (w=0; w<CountFreq; w++)
	{
		P=0.;
		for (i=1; i<KE-1; i++)
		{
			P=P+pow(Real_Point[w][i],2.0)+\
				pow(Imag_Point[w][i],2.0);

		}
		//P=sqrt(P)/sqrt(pow(Real_Ref[w],2.0)+\
			          // pow(Imag_Ref[w],2.0));

		fprintf(fp,"%lf %lf\n",SweepFreq[w],P);
	}
	fclose(fp);

	for (k=0;k<KE;k++)
	{
		printf("%d %lf %lf\n",k,psi_rl[k],psi_im[k]);
	}

	fp=fopen("prl_SFDTD.txt","w");
	for (k=0;k<KE;k++)
	{
		fprintf(fp,"%lf\n",psi_rl[k]);
	}
	fclose(fp);

	fp=fopen("pim_SFDTD.txt","w");
	for (k=0;k<KE;k++)
	{
		fprintf(fp,"%lf\n",psi_im[k]);
	}
	fclose(fp);

	fp=fopen("eigenfunction_SFDTD.txt","w");
	w=937;
	for (i=0; i<KE; i++)
	{
		fprintf(fp,"%lf %lf\n",Real_Point[w][i],Imag_Point[w][i]);
	}
	fclose(fp);
	return 0;
}





