%  ˺PCD㷨ѹֵ֪ͼ޸
%  ο: M. Elad, B. Matalon, and M. Zibulevsky, "Coordinate and subspace 
%  optimization methods for linear least squares with non-quadratic regularization," 
%  Appl. Comput. Harmon. Anal., vol. 23, pp. 346C367, Nov. 2007.
%  ˣɳ, ۴ѧ
%  Email: wsha@eee.hku.hk; dr.weisha@gmail.com
%  תʱ뱣ע

function PCD_Inpainting;

clc;clear

%  ͼģ
I=imread('lena256.bmp');  %  lenaͼ񣬿Գͼ
M=imread('mask_bmp.bmp'); %  ģͼ񣬿Գͼ
X=double(I)/255;          %  ԭʼһ
mask=double(M>0);         %  ģ(ɫ0)
N=length(X);              %  ԭʼͼС

load ww1                   %  С任1
load ww2                   %  С任2
load ww3                   %  С任3
load ww4                   %  С任4
ww5=dct(eye(N,N));         %  ɢұ任5
ww=[ww1;ww2;ww3;ww5];      %  ֵ
N_d=4;                     %  ֵĿ

W_i=WL_for(ww,X);          %  С任
max_e=max(max(full(abs(W_i)))); %  ϵ
threshold=0.1;             %  ϡ軯ֵ(С任)
th_v=(max_e*threshold);    %  ֵ

Y=X.*(mask);               %  û˵Ϊ

X_r=zeros(N_d*N,N_d*N);    %  ָ
N_iter=200;                %  

%  Эװ뾶Ӧֵ diag(A'*A)^{-1}
mm=10;
sum1=0;
for m=1:mm
    r_test=randn(N,N);                      %  ˹ֲЭ1
    r_test=r_test.*(mask);                  %  û˵Ϊ
    r_test=WL_for(ww,r_test);               %  ֵ任õ任ͼ
    sum1=sum1+cov(r_test);                  %  Э
end
sum1=sum1/mm;                               %  ƽֵ
sum2=1./diag(abs(sum1));                    %  õֵÿԭӷ
W=diag(sum2);                               %  õ½ľʽ
gamma=W*ones(N_d*N,N_d*N);                  %  õֵľʽ

mu=0.1;                                     %  (***Ҫ޸ı֤ȶ)

for m=1:N_iter
    N_iter-m
    
    X_b=X_r;                            %  ʼ任ϵ
    X_t=WL_back(ww,X_r);                %  ֵ䷴任õʱͼ
    X_m=mask.*X_t;                      %  û˵Ϊ
    R_m=mask.*(Y-X_m);                  %  в
    X_s=X_r+W*WL_for(ww,R_m);           %  ֵ任±任ϵ
    X_r=Threshold_F(X_s,th_v*gamma);    %  任ϵֵ
    
    X_r=X_b+mu*(X_r-X_b);               %  £ҪӦmu
    th_v=th_v*0.90;                     %  ֵɳ
    
    if (th_v<1e-3)                      %  ֵСʱضϵ
        break;
    end
    
    %  ԭʼͼȵķֵPSNR
    errorx=sum(sum(abs(WL_back(ww,X_r)-X).^2));   %  MSE
    psnr=10*log10(1*1/(errorx/N/N));  %  PSNR
    disp('ֵȣ')
    disp(psnr)

end

figure(1)
subplot(2,2,1)
imshow(uint8(X*255))
title('ԭʼͼ')
subplot(2,2,2)
imshow(uint8((Y)*255))
title('')
subplot(2,2,3)
imshow(uint8(full(WL_back(ww,X_r))*255))
ss=sprintf('ָͼPSNR: %0.2f',psnr);
title(ss)
subplot(2,2,4)
imshow(uint8(full(WL_back(ww,X_r)-X)*255))
title('ͼ')

%  ֵ任ֵ䷴任Բʾ죩
function MM=WL_for(ww,M)
MM=(ww*(M)*ww');      %  2d image

function MM=WL_back(ww,M)
MM=(ww'*(M)*ww);      %  2d image

%  ֵ
function X_th=Threshold_F(X,threshold)

%  ֵ
flag1=X>(threshold);
flag2=X<-(threshold);
flag3=flag1 | flag2;
X_th=X-double(flag1).*threshold;
X_th=X_th+double(flag2).*threshold;
X_th=X_th.*flag3;


