%  ˺FISTA㷨ѹ֪Radon任ϲɨӦã
%  οףAmir Beck and Marc Teboulle, "A Fast Iterative Shrinkage-Thresholding Algorithm for 
%  Linear Inverse Problems," SIAM J. IMAGING SCIENCES, Vol. 2, No. 1, pp.183-202, 2009.
%  ˣɳ, ۴ѧ
%  Email: wsha@eee.hku.hk; dr.weisha@gmail.com
%  תʱ뱣ע

function FISTA_Radon;

clc;clear

X=phantom(256);           %  Phantomͼ
load ww                   %  С任
W_i=WL_for(ww,X);         %  С任
max_e=max(max(full(abs(W_i)))); %  ϵ
threshold=0.005;          %  ϡ軯ֵ(С任)
th_v=(max_e*threshold);   %  ֵ

N=length(X);              %  ԭʼͼС

% radon任
angle=0:2:180;            %  ͶӰǶ
Y=radon(X,angle);         %  任

X_r=zeros(N,N);  %  ָ
N_iter=200;      %  
c=4;             %   Ҫȶͬʱ٣
gamma=1/c;       %  ϵŻ

t=1;             %  Ӧϵ

for m=1:N_iter
    N_iter-m
    
    t_p=t;                            %  ¼֮ǰϵ
    X_p=X_r;                          %  ¼֮ǰСϵ

    X_t=WL_back(ww,X_r);              %  С任õʱͼ
    X_m=radon(X_t,angle);             %  任
    R_m=iradon(Y-X_m,angle,'linear','Ram-Lak',1,N);  % 任İӣ任
    X_s=X_r+gamma*WL_for(ww,R_m);     %  С任Сϵ
    X_r=Threshold_F(X_s,th_v/c);      %  Сϵֵ

    t=(1+sqrt(1+4*t^2))/2;            %  µĵϵ
    X_r=X_r+(t_p-1)/t*(X_r-X_p);      %  Сϵ1
    %X_r=X_r+(t-1)/(t+1)*(X_r-X_p);   %  Сϵ2
    
    th_v=th_v*0.99                    %  ֵɳ
    
    if (th_v<1e-3)                    %  ֵСʱضϵ
        break;
    end
    
    %  ԭʼͼȵķֵPSNR
    errorx=sum(sum(abs(WL_back(ww,X_r)-X).^2));   %  MSE
    psnr=10*log10(1*1/(errorx/N/N));  %  PSNR
    disp('ֵȣ')
    disp(psnr)

end

figure(1)
subplot(2,2,1)
imshow(uint8(X*255))
title('ԭʼͼ')
subplot(2,2,2)
imshow(Y,[])
title('任')
subplot(2,2,3)
imshow(uint8(full(WL_back(ww,X_r))*255))
ss=sprintf('ѹлָͼPSNR: %0.2f',psnr);
title(ss)
subplot(2,2,4)
Rec_back=iradon(Y,angle,'linear','Ram-Lak',1,256);  %  none
errorx=sum(sum(abs(Rec_back-X).^2));   %  MSE
psnr=10*log10(1*1/(errorx/N/N));  %  PSNR
imshow(uint8(Rec_back*255))
ss=sprintf('˲ͶӰָͼPSNR: %0.2f',psnr);
title(ss)

%  С任ͷ任
function MM=WL_for(ww,M)
MM=(ww*(M)*ww');     %  2d image
%MM=(ww*sparse(M));  %  1d signal

function MM=WL_back(ww,M)
MM=(ww'*(M)*ww);      %  2d image
%MM=(ww'*sparse(M));  %  1d signal

%  ֵ
function X_th=Threshold_F(X,threshold)

%  ֵ
flag1=X>(threshold);
flag2=X<-(threshold);
flag3=flag1 | flag2;
X_th=X-double(flag1).*threshold;
X_th=X_th+double(flag2).*threshold;
X_th=X_th.*flag3;

