%  ˺FISTA㷨ѹ֪Ҷ任ŹӦã
%  οףAmir Beck and Marc Teboulle, "A Fast Iterative Shrinkage-Thresholding Algorithm for 
%  Linear Inverse Problems," SIAM J. IMAGING SCIENCES, Vol. 2, No. 1, pp.183-202, 2009.
%  ˣɳ, ۴ѧ
%  Email: wsha@eee.hku.hk; dr.weisha@gmail.com
%  תʱ뱣ע

function FISTA_FT;

clc;clear

%  ͼ
A={'phantom256.bmp' 'fruits256.bmp' 'cameraman256.bmp' 'lena256.bmp'...
    'peppers256.bmp' 'boat256.bmp' 'baboon256.bmp'};

I=imread(A{3});           %  1ʾphantomͼ񣬿Գͼ
X=double(I)/255;          %  ԭʼһ
load ww                   %  С任
W_i=WL_for(ww,X);         %  С任
max_e=max(max(full(abs(W_i)))); %  ϵ
threshold=0.005;          %  ϡ軯ֵ(С任)
th_v=(max_e*threshold);   %  ֵ

N=length(X);              %  ԭʼͼС

% (Y=A*XA̬ҪùݶȼҪ)
% A=rand(N/4,N);          %  25%
% A=A/norm(A);            %  һ

load mask_radial;         %  mask30%
Y=FT_for(mask_matrix,X);  %  Ҷ任ϵΪ

X_r=zeros(N,N);  %  ָ
N_iter=100;      %  
c=1;             %  
gamma=1/c;       %  ϵŻ

t=1;             %  Ӧϵ

for m=1:N_iter
    N_iter-m
    
    t_p=t;                            %  ¼֮ǰϵ
    X_p=X_r;                          %  ¼֮ǰСϵ

    X_t=WL_back(ww,X_r);              %  С任õʱͼ
    X_m=FT_for(mask_matrix,X_t);      %  Ҷ任
    R_m=FT_back(mask_matrix,(Y-X_m)); %  в
    X_s=X_r+gamma*WL_for(ww,R_m);     %  С任Сϵ
    X_r=Threshold_F(X_s,th_v/c);      %  Сϵֵ

    t=(1+sqrt(1+4*t^2))/2;            %  µĵϵ
    X_r=X_r+(t_p-1)/t*(X_r-X_p);      %  Сϵ1
    %X_r=X_r+(t-1)/(t+1)*(X_r-X_p);   %  Сϵ2
    
    th_v=th_v*0.9;                    %  ֵɳ
    
    if (th_v<1e-3)                    %  ֵСʱضϵ
        break;
    end
    
    %  ԭʼͼȵķֵPSNR
    errorx=sum(sum(abs(WL_back(ww,X_r)-X).^2));   %  MSE
    psnr=10*log10(1*1/(errorx/N/N));  %  PSNR
    disp('ֵȣ')
    disp(psnr)
 
end

figure(1)
subplot(2,2,1)
imshow(uint8(X*255))
title('ԭʼͼ')
subplot(2,2,2)
imshow(uint8(real(Y)*255))
title('Ҷ')
subplot(2,2,3)
imshow(uint8(full(WL_back(ww,X_r))*255))
ss=sprintf('ָͼPSNR: %0.2f',psnr);
title(ss)
subplot(2,2,4)
imshow(uint8(full(WL_back(ww,X_r)-X)*255))
title('ͼ')

%  С任ͷ任
function MM=WL_for(ww,M)
MM=(ww*(M)*ww');     %  2d image
%MM=(ww*sparse(M));  %  1d signal

function MM=WL_back(ww,M)
MM=(ww'*(M)*ww);      %  2d image
%MM=(ww'*sparse(M));  %  1d signal

%  ֵ
function X_th=Threshold_F(X,threshold)

%  ֵ
flag1=X>(threshold);
flag2=X<-(threshold);
flag3=flag1 | flag2;
X_th=X-double(flag1).*threshold;
X_th=X_th+double(flag2).*threshold;
X_th=X_th.*flag3;

% Ҷ任ͷ任
function MM=FT_for(mask,M)
M=real(M);
MM=mask.*(fftshift(fft2(M)));

function MM=FT_back(mask,M)
MM=real(ifft2(ifftshift(mask.*M)));

